﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityStandardAssets.Vehicles.Car;

public class MyCar : MonoBehaviour
{
    public RacingGameManager Manager;

    protected CarController m_Car; // the car controller we want to use
    public List<CarPosInfo> Road
    {
        get
        {
            if (Manager == null)
                return null;
            return Manager.Road;
        }
    }

    protected bool RaceStated { get => Manager.RaceStarted; }
    const int StageCount = 10;
    protected int Stage = 0;
    protected int mRoundDone = 0;
    public int IntRoundDone { get => mRoundDone; }
    public float time;
    protected int TargetIdx = 0;

    protected void UpdateTarget()
    {

        var tr = Road[TargetIdx];
        var trDir = tr.Rot * Vector3.forward;
        var myDir = tr.Pos - transform.position;

        if (Vector3.Dot(myDir, trDir) < 4)
            TargetIdx = (TargetIdx + 1) % Road.Count;
    }

    public virtual void SetCarPos(int PosIdx)
    {
        if (Road.Count < 1)
            return;

        if (PosIdx < 0)
            PosIdx = Road.Count - ((-PosIdx) % Road.Count);
        else
            PosIdx = PosIdx % Road.Count;

        //LoadedPos = PosIdx;
        var tr = Road[PosIdx];
        transform.position = tr.Pos + new Vector3(0, 0, 0.3f);
        transform.rotation = tr.Rot;
        GetComponent<Rigidbody>().velocity = Vector3.zero;
        GetComponent<Rigidbody>().angularVelocity = Vector3.zero;
        TargetIdx = (PosIdx + 1) % Road.Count;
    }



    public void SetCarAtRandomPos()
    {
        if (Road.Count == 0)
            return;
        var rd = new System.Random();
        var LoadedPos = rd.Next(0, Road.Count - 1);
        SetCarPos(LoadedPos);
    }

    public virtual void Start()
    {
        Manager.Cars.Add(this);
        Manager.LoadRoad();
        m_Car = GetComponent<CarController>();
        SetCarPos(0);
        mRoundDone = 0;
        time = Time.time;
    }

    public bool Finished()
    {
        return Manager != null && mRoundDone >= Manager.MaxRoundCount;
    }
    protected void CheckSage()
    {
        if (Stage < StageCount)
        {
            var Idx = Stage + 1;
            Idx = (int)((Road.Count - 1) * ((float)Idx / (float)StageCount));
            var NextPt = Road[Idx];
            if (Vector3.Distance(transform.position, NextPt.Pos) < 10)
            {
                if (Stage + 1 < StageCount)
                    Stage += 1;
                else
                {
                    var trDir = NextPt.Rot * Vector3.forward;
                    var myDir = NextPt.Pos - transform.position;
                    if (Vector3.Dot(myDir, trDir) < 0) // arrived
                    {
                        mRoundDone += 1;
                        Debug.Log("RoundDone: " + mRoundDone);
                        Stage = 0;
                        if (Finished())
                            time = Time.time - time;
                    }
                }
            }
        }
    }

    public float RoundDone()
    {
        return mRoundDone + (float)Stage / (float)StageCount;
    }

    void Update()
    {
        CheckSage();
    }
}

